/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Database {
    private final int VIBRATION;
    private final int SOUND;
    private final int LIVELLO;
    private final int PUNTEGGIO;
    private final byte[] valori = new byte[]{70, 86, 70, 78, 68};
    private RecordStore rs = null;

    Database() {
        this.VIBRATION = 1;
        this.SOUND = 2;
        this.LIVELLO = 3;
        this.PUNTEGGIO = 4;
    }

    private void openRecordStore() throws RecordStoreException {
        if (this.rs == null) {
            this.rs = RecordStore.openRecordStore((String)"Opzioni", (boolean)true);
        }
        if (this.rs.getNumRecords() == 0) {
            byte[] b = new byte[]{86};
            this.rs.addRecord(b, 0, 1);
            this.rs.addRecord(b, 0, 1);
            byte[] c = new byte[]{70};
            this.rs.addRecord(c, 0, 1);
            String pp = "0.0.0";
            this.rs.addRecord(pp.getBytes(), 0, pp.length());
            this.rs.addRecord(pp.getBytes(), 0, pp.length());
            this.rs.addRecord(pp.getBytes(), 0, pp.length());
        }
    }

    private void closeRecordStore() throws RecordStoreException {
        if (this.rs != null) {
            this.rs.closeRecordStore();
            this.rs = null;
        }
    }

    boolean getUseVibration() {
        try {
            return this.getValue(1) == 86;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean getUseSound() {
        try {
            return this.getValue(2) == 86;
        }
        catch (Exception e) {
            return false;
        }
    }

    short leggiLivello() {
        try {
            byte v = this.getValue(3);
            if (v == 70) {
                return 0;
            }
            if (v == 78) {
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            return 0;
        }
    }

    String leggiPunteggio(int l) throws RecordStoreException {
        this.openRecordStore();
        byte[] bytes = this.rs.getRecord(4 + l);
        this.closeRecordStore();
        return new String(bytes);
    }

    void setUseVibration(boolean bool) {
        int v = 0;
        if (bool) {
            v = 1;
        }
        try {
            this.setValue(1, this.valori[v]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setUseSound(boolean bool) {
        int v = 0;
        if (bool) {
            v = 1;
        }
        try {
            this.setValue(2, this.valori[v]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void assegnaLivello(int livello) {
        try {
            this.setValue(3, this.valori[livello + 2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void assegnaPunteggio(int l, String punteggio) throws RecordStoreException {
        this.openRecordStore();
        this.rs.setRecord(4 + l, punteggio.getBytes(), 0, punteggio.length());
        this.closeRecordStore();
    }

    private void setValue(int id, byte b) throws RecordStoreException {
        byte[] ba = new byte[]{b};
        this.openRecordStore();
        this.rs.setRecord(id, ba, 0, 1);
        this.closeRecordStore();
    }

    private byte getValue(int id) throws RecordStoreException {
        this.openRecordStore();
        byte[] barray = this.rs.getRecord(id);
        this.closeRecordStore();
        return barray[0];
    }
}

